# Contributing to Event Dispatcher

Thank you for considering contributing to the Event Dispatcher package! We welcome contributions from the community.

## How to Contribute

### Reporting Bugs

If you find a bug, please create an issue on GitHub with:

- A clear, descriptive title
- Steps to reproduce the issue
- Expected behavior
- Actual behavior
- PHP version and environment details
- Code samples if applicable

### Suggesting Enhancements

We welcome feature requests! Please create an issue with:

- A clear description of the feature
- Use cases and examples
- Why this feature would be useful

### Pull Requests

1. **Fork the repository** and create your branch from `main`
2. **Install dependencies**: `composer install`
3. **Make your changes**
4. **Add tests** if applicable
5. **Ensure code quality**:
   - Follow PSR-12 coding standards
   - Add PHPDoc comments
   - Keep backward compatibility in mind
6. **Test your changes**: Run the examples to ensure everything works
7. **Commit your changes** with clear, descriptive commit messages
8. **Push to your fork** and submit a pull request

### Coding Standards

- Follow [PSR-12](https://www.php-fig.org/psr/psr-12/) coding style
- Use meaningful variable and method names
- Add PHPDoc blocks for classes and methods
- Keep methods focused and single-purpose
- Write clear commit messages

### Testing

Before submitting a pull request:

1. Run all example files to ensure they work:
   ```bash
   php run-examples.php
   ```

2. Test with different PHP versions if possible (7.4, 8.0, 8.1, 8.2, 8.3)

3. If adding new features, create example usage in the `examples` directory

### Documentation

- Update README.md if adding new features
- Add examples for new functionality
- Update PHPDoc comments
- Keep documentation clear and concise

## Development Setup

1. Clone the repository:
   ```bash
   git clone https://github.com/TaranpreetSinghRayat/event-dispatcher.git
   cd event-dispatcher
   ```

2. Install dependencies:
   ```bash
   composer install
   ```

3. Run examples:
   ```bash
   php run-examples.php
   ```

## Code of Conduct

- Be respectful and inclusive
- Welcome newcomers
- Focus on constructive feedback
- Help others learn and grow

## Questions?

If you have questions, feel free to:

- Open an issue on GitHub
- Contact us at admin@tweekersnut.com

## License

By contributing, you agree that your contributions will be licensed under the MIT License.

---

Thank you for contributing to Event Dispatcher! 🎉

